-- name: \\#ff805a\\Dynamic Lives Icon v1.5
-- description: Renders the Lives icon with color. It even changes based on what caps you are wearing! Incompatible with custom HUDs and the player list. IS compatible with Character Select.\n\nMod By EmilyEmmi.\n\nAlso, feel free to use this for your own stuff.
-- deluxe: true

local defaultIcons = {
    [gTextures.mario_head] = true,
    [gTextures.luigi_head] = true,
    [gTextures.toad_head] = true,
    [gTextures.waluigi_head] = true,
    [gTextures.wario_head] = true,
}

-- replaces the standard lives display, unless the hud or lives counter is 
local CS_ACTIVE
function on_hud_render_behind()
    CS_ACTIVE = _G.charSelectExists
    djui_hud_set_font(FONT_HUD)
    djui_hud_set_resolution(RESOLUTION_N64)
    --djui_hud_set_render_behind_hud(true)

    if (not hud_is_hidden()) then
        local dispFlags = hud_get_value(HUD_DISPLAY_FLAGS)
        local valid = true
        if CS_ACTIVE then
            local TEX_CS_ICON = _G.charSelect.character_get_life_icon(0)
            if TEX_CS_ICON == nil or not defaultIcons[TEX_CS_ICON] then valid = false end
        else
            valid =  (dispFlags & HUD_DISPLAY_FLAGS_LIVES) ~= 0
        end
        if valid then
            --if (dispFlags & HUD_DISPLAY_FLAGS_STAR_COUNT) ~= 0 then
            --[[if (gMarioStates[0].marioBodyState.capState == MARIO_HAS_DEFAULT_CAP_OFF) or (gMarioStates[0].marioBodyState.modelState & MODEL_STATE_NOISE_ALPHA) ~= 0 then
                hud_set_value(HUD_DISPLAY_FLAGS, dispFlags &~ HUD_DISPLAY_FLAG_LIVES)
            else
                hud_set_value(HUD_DISPLAY_FLAGS, dispFlags | HUD_DISPLAY_FLAG_LIVES)
            end]]
            --local lives = hud_get_value(HUD_DISPLAY_LIVES)


            --djui_hud_set_render_behind_hud(false)

            render_player_head(0, 22, 15, 1, 1)
            djui_hud_set_color(255, 255, 255, 255)
            --[[djui_hud_print_text("x", 22+16, 15, 1)
            if lives >= 0 then
                djui_hud_print_text(tostring(lives), 22+32, 15, 1)
            else
                djui_hud_print_text("m"..tostring(-lives), 22+32, 15, 1)
            end]]
        end
        
        --if not CS_ACTIVE then -- current version of character select does not place head in camera slot
            valid = (dispFlags & HUD_DISPLAY_FLAGS_CAMERA) ~= 0
        --end
        if valid then
            local x = djui_hud_get_screen_width() - 38
            local y = 205
            local cameraHudStatus = hud_get_value(HUD_DISPLAY_CAMERA_STATUS)

            if cameraHudStatus & CAM_STATUS_MODE_GROUP == CAM_STATUS_MARIO then
                render_player_head(0, x, y, 1, 1)
            end
        end
    end

    if gServerSettings.enablePlayersInLevelDisplay ~= 0 and gNetworkPlayers[0].currCourseNum ~= 0 and obj_get_first_with_behavior_id(id_bhvActSelector) ~= nil then
        local course = gNetworkPlayers[0].currCourseNum
        local stars = save_file_get_star_flags(get_current_save_file_num() - 1, course - 1)
        local maxStar = 0

        local allInRow = true
        local missing = false
        for i = 0, 5 do
            if stars & 2 ^ i ~= 0 then
                maxStar = i
                if missing then
                    allInRow = false
                end
            else
                missing = true
            end
        end

        if allInRow and maxStar < 5 then
            maxStar = maxStar + 1
        end

        for a = 1, maxStar + 1 do
            --djui_chat_message_create(tostring(djui_hud_get_screen_width()))
            local x = (139 - maxStar * 17 + a * 34) + djui_hud_get_screen_width() * 0.5 - 177
            for b = 1, MAX_PLAYERS - 1 do
                local np = gNetworkPlayers[b]
                --djui_chat_message_create(tostring(b)..tostring(np.currCourseNum)..tostring(course))
                if np and np.connected and np.currCourseNum == course and np.currActNum == a then
                    render_player_head(b, x - 4, 17, 1, 1, true)
                    break
                end
            end
        end
    end
end

function on_hud_render()
    -- player list (now actually works!)
    if djui_is_playerlist_open() then
        djui_hud_set_resolution(RESOLUTION_DJUI)
        local x = djui_hud_get_screen_width() * 0.5 - 400
        local y = djui_hud_get_screen_height() * 0.5 - 36 * 8 - 2
        for i = 0, MAX_PLAYERS - 1 do
            local np = gNetworkPlayers[i]
            --djui_chat_message_create(tostring(b)..tostring(np.currCourseNum)..tostring(course))
            if (np and np.connected) then
                y = y + 36
                local special = (i == 0 or is_player_active(gMarioStates[i]) ~= 0)
                render_player_head(i, x, y, 2, 2, not special)
            end
        end
    end
end

hook_event(HOOK_ON_HUD_RENDER_BEHIND, on_hud_render_behind)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)